﻿// --------------------------------------------------------------------------------------
// Microsoft Word 2003 (Windows) XML Library
// --------------------------------------------------------------------------------------

// get Worksheet Tag
function getWorkSheet(xml,sheetName)
{
	var tagObj = xml.getElementsByTagName("Worksheet");
	for (var i=0; i<tagObj.length; i++)
	{
		var n = tagObj[i].attributes[0].value;
		if (n == sheetName) return tagObj[i];
	}
	return null;
}

// get Worksheet Row Size(height)
function getWorkSheetRowCount(tagObj)
{
	var tableObj = tagObj.getElementsByTagName("Table")[0];
	return tableObj.getElementsByTagName("Row").length;
}

// get Worksheet Col Size(width)
function getWorkSheetColCount(tagObj)
{
	var tableObj = tagObj.getElementsByTagName("Table")[0];
	var rowObj = tagObj.getElementsByTagName("Row")[0];
	return rowObj.getElementsByTagName("Cell").length;
}

// get Cell Data
function getCellData(xml,sheetName,xPos,yPos)
{
	var wsObj = getWorkSheet(xml,sheetName);
	if (!wsObj) return null;
	var wSize = getWorkSheetColCount(wsObj);
	var hSize = getWorkSheetRowCount(wsObj);
	if ((xPos < 0) || (xPos >wSize) || (yPos < 0) || (yPos > hSize)) return null;
	var tableObj = wsObj.getElementsByTagName("Table")[0];
	var rowObj = tableObj.getElementsByTagName("Row")[yPos];
	var cellObj = rowObj.getElementsByTagName("Cell")[xPos];
	return cellObj.getElementsByTagName("Data")[0].firstChild.nodeValue;
}

// get Sheet Count
function getWorkSheetCount(xml)
{
	return xml.getElementsByTagName("Worksheet").length;
}

// getWorkSheet Name
function getWorkSheetName(xml,num)
{
	var tagObj = xml.getElementsByTagName("Worksheet")[num];
	return tagObj.attributes[0].value;
}